/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.impl;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.impl.FutureImpl;

public final class ReadyFutureImpl<R>
implements FutureImpl<R> {
    private static final ThreadCache.CachedTypeIndex<ReadyFutureImpl> CACHE_IDX = ThreadCache.obtainIndex(ReadyFutureImpl.class, 4);
    protected R result;
    private Throwable failure;
    private boolean isCancelled;

    public static <R> ReadyFutureImpl<R> create() {
        ReadyFutureImpl<R> future = ReadyFutureImpl.takeFromCache();
        if (future != null) {
            future.isCancelled = true;
            return future;
        }
        return new ReadyFutureImpl<R>();
    }

    public static <R> ReadyFutureImpl<R> create(R result2) {
        ReadyFutureImpl<R> future = ReadyFutureImpl.takeFromCache();
        if (future != null) {
            future.result = result2;
            return future;
        }
        return new ReadyFutureImpl<R>(result2);
    }

    public static <R> ReadyFutureImpl<R> create(Throwable failure2) {
        ReadyFutureImpl<R> future = ReadyFutureImpl.takeFromCache();
        if (future != null) {
            future.failure = failure2;
            return future;
        }
        return new ReadyFutureImpl<R>(failure2);
    }

    private static <R> ReadyFutureImpl<R> takeFromCache() {
        return ThreadCache.takeFromCache(CACHE_IDX);
    }

    private ReadyFutureImpl() {
        this(null, null, true);
    }

    private ReadyFutureImpl(R result2) {
        this(result2, null, false);
    }

    private ReadyFutureImpl(Throwable failure2) {
        this(null, failure2, false);
    }

    private ReadyFutureImpl(R result2, Throwable failure2, boolean isCancelled) {
        this.result = result2;
        this.failure = failure2;
        this.isCancelled = isCancelled;
    }

    @Override
    public void addCompletionHandler(CompletionHandler<R> completionHandler) {
        if (this.isCancelled) {
            completionHandler.cancelled();
        } else if (this.failure != null) {
            completionHandler.failed(this.failure);
        } else {
            completionHandler.completed(this.result);
        }
    }

    @Override
    public R getResult() {
        return this.result;
    }

    public void setResult(R result2) {
        throw new IllegalStateException("Can not be reset on ReadyFutureImpl");
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.isCancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.result;
    }

    @Override
    public R get(long timeout, TimeUnit unit2) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        if (this.result != null) {
            return this.result;
        }
        throw new TimeoutException();
    }

    @Override
    public void failure(Throwable failure2) {
        throw new IllegalStateException("Can not be reset on ReadyFutureImpl");
    }

    @Override
    public void result(R result2) {
        throw new IllegalStateException("Can not be reset on ReadyFutureImpl");
    }

    private void reset() {
        this.result = null;
        this.failure = null;
        this.isCancelled = false;
    }

    @Override
    public void markForRecycle(boolean recycleResult) {
        this.recycle(recycleResult);
    }

    @Override
    public void recycle() {
        this.recycle(false);
    }

    @Override
    public void recycle(boolean recycleResult) {
        if (recycleResult && this.result != null && this.result instanceof Cacheable) {
            ((Cacheable)this.result).recycle();
        }
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, this);
    }
}

